/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import org.antlr.works.ate.ATEGutter;
import org.antlr.works.ate.ATEOverlayManager;
import org.antlr.works.ate.ATEPanelDelegate;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.analysis.ATEAnalysisColumn;
import org.antlr.works.ate.analysis.ATEAnalysisManager;
import org.antlr.works.ate.folding.ATEFoldingManager;
import org.antlr.works.ate.gutter.ATEGutterColumnManager;
import org.antlr.works.ate.swing.ATEAutoIndentation;
import org.antlr.works.ate.swing.ATEKeyBindings;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngine;
import org.antlr.works.ate.syntax.generic.ATESyntaxEngineDelegate;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.xjlib.appkit.frame.XJFrame;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.utils.XJSmoothScrolling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATEPanel
extends JPanel
implements XJSmoothScrolling.ScrollingDelegate,
ATESyntaxEngineDelegate {
    protected XJFrame parentFrame;
    protected XJSmoothScrolling smoothScrolling;
    protected ATEPanelDelegate delegate;
    protected ATETextPane textPane;
    protected ATEKeyBindings keyBindings;
    protected ATEGutter gutter;
    protected ATEAnalysisColumn analysisColumn;
    protected ATEGutterColumnManager gutterColumnsManager;
    protected ATEFoldingManager foldingManager;
    protected ATEOverlayManager underlyingManager;
    protected ATEAnalysisManager analysisManager;
    protected ATESyntaxEngine engine;
    protected ATEAutoIndentation autoIndent;
    protected TextPaneListener textPaneListener;
    protected boolean syntaxColoring = false;
    protected int caretPosition;
    protected CaretListener cl;
    protected MouseListener ml;
    protected MouseMotionListener mml;
    protected static final String unixEndOfLine = "\n";
    protected static int ANALYSIS_COLUMN_WIDTH = 18;

    public ATEPanel(XJFrame parentFrame) {
        this(parentFrame, null);
    }

    public ATEPanel(XJFrame parentFrame, StyledEditorKit editorKit) {
        super(new BorderLayout());
        this.setParentFrame(parentFrame);
        this.autoIndent = new ATEAutoIndentation(this);
        this.createTextPane(editorKit);
    }

    public XJFrame getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(XJFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void setParserEngine(ATESyntaxEngine engine) {
        this.engine = engine;
        this.engine.setDelegate(this);
        this.engine.refreshColoring();
    }

    public ATESyntaxEngine getParserEngine() {
        return this.engine;
    }

    public void setDelegate(ATEPanelDelegate delegate) {
        this.delegate = delegate;
    }

    public void setGutterColumnManager(ATEGutterColumnManager columnManager) {
        this.gutterColumnsManager = columnManager;
    }

    public void setFoldingManager(ATEFoldingManager manager) {
        this.foldingManager = manager;
    }

    public void setUnderlyingManager(ATEOverlayManager manager) {
        this.underlyingManager = manager;
    }

    public void setAnalysisManager(ATEAnalysisManager manager) {
        this.analysisManager = manager;
    }

    public ATEAnalysisManager getAnalysisManager() {
        return this.analysisManager;
    }

    public void setEditable(boolean flag) {
        this.textPane.setEditable(flag);
        this.textPane.setWritable(flag);
    }

    public void setAutoIndent(boolean flag) {
        this.autoIndent.setEnabled(flag);
    }

    public boolean autoIndent() {
        return this.autoIndent.enabled();
    }

    public void setCaretPosition(int position) {
        this.setCaretPosition(position, true, false);
    }

    public void setCaretPosition(int position, boolean adjustScroll, boolean animate) {
        int adjustedPosition = Math.min(position, this.getText().length());
        if (adjustScroll) {
            this.scrollCenterToPosition(adjustedPosition, animate);
        }
        if (!animate) {
            this.textPane.setCaretPosition(adjustedPosition);
        }
    }

    public int getCaretPosition() {
        return this.textPane.getCaretPosition();
    }

    public void setHighlightCursorLine(boolean flag) {
        this.textPane.setHighlightCursorLine(flag);
    }

    public void setUnderlying(boolean flag) {
        this.underlyingManager.setUnderlying(flag);
    }

    public boolean isUnderlying() {
        return this.underlyingManager.isUnderlying();
    }

    public void setFoldingEnabled(boolean flag) {
        this.gutter.setFoldingEnabled(flag);
    }

    public void setLineNumberEnabled(boolean flag) {
        this.gutter.setLineNumberEnabled(flag);
    }

    public void setEnableRecordChange(boolean flag) {
        if (flag) {
            this.textPaneListener.enable();
        } else {
            this.textPaneListener.disable();
        }
    }

    public void scrollCenterToPosition(int position, boolean animate) {
        try {
            Rectangle r = this.textPane.modelToView(position);
            if (r != null) {
                Rectangle vis = this.getVisibleRect();
                r.y -= vis.height / 2;
                r.height = vis.height;
                if (animate) {
                    this.caretPosition = position;
                    this.smoothScrolling.scrollTo(r);
                } else {
                    this.textPane.scrollRectToVisible(r);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void smoothScrollingDidComplete() {
        this.textPane.setCaretPosition(this.caretPosition);
    }

    public void setAnalysisColumnVisible(boolean visible) {
        this.analysisColumn.setVisible(visible);
        if (visible) {
            this.analysisColumn.setPreferredSize(new Dimension(ANALYSIS_COLUMN_WIDTH, 0));
        } else {
            this.analysisColumn.setPreferredSize(new Dimension(0, 0));
        }
    }

    public boolean isAnalysisColumnVisible() {
        return this.analysisColumn.isVisible();
    }

    public void toggleAnalysis() {
        this.setAnalysisColumnVisible(!this.isAnalysisColumnVisible());
    }

    public void setSyntaxColoring(boolean flag) {
        this.syntaxColoring = flag;
        this.textPane.repaint();
    }

    public boolean isSyntaxColoring() {
        return this.syntaxColoring;
    }

    public ATEKeyBindings getKeyBindings() {
        return this.keyBindings;
    }

    public void toggleSyntaxColoring() {
        this.setSyntaxColoring(!this.isSyntaxColoring());
    }

    public void setEditorKit(StyledEditorKit editorKit) {
        this.textPane.setEditorKit(editorKit);
        this.textPaneListener = new TextPaneListener();
        this.textPane.getDocument().addDocumentListener(this.textPaneListener);
        this.textPane.getDocument().putProperty("__EndOfLine__", unixEndOfLine);
    }

    public void damage() {
        if (this.underlyingManager != null) {
            this.underlyingManager.reset();
        }
        if (this.gutter != null) {
            this.gutter.updateSize();
            this.gutter.revalidate();
            this.gutter.markDirty();
        }
    }

    public void refresh() {
        this.damage();
        if (this.engine != null) {
            this.engine.refreshColoring();
        }
        this.repaint();
    }

    public void changeOccurred() {
        this.gutter.markDirty();
        this.parse();
    }

    public int getSelectionStart() {
        return this.textPane.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textPane.getSelectionEnd();
    }

    public String getSelectedText() {
        return this.textPane.getSelectedText();
    }

    public List<ATEToken> getTokens() {
        return this.engine == null ? null : this.engine.getTokens();
    }

    public List<ATELine> getLines() {
        return this.engine == null ? null : this.engine.getLines();
    }

    public int getCurrentLinePosition() {
        return this.getLinePositionAtIndex(this.getCaretPosition());
    }

    public int getLinePositionAtIndex(int index) {
        return this.getLineIndexAtTextPosition(index) + 1;
    }

    public int getCurrentColumnPosition() {
        return this.getColumnPositionAtIndex(this.getCaretPosition());
    }

    public int getColumnPositionAtIndex(int index) {
        int lineIndex = this.getLineIndexAtTextPosition(index);
        Point linePosition = this.getLineTextPositionsAtLineIndex(lineIndex);
        if (linePosition == null) {
            return 1;
        }
        return this.getCaretPosition() - linePosition.x + 1;
    }

    public int getLineIndexAtTextPosition(int pos) {
        List<ATELine> lines = this.getLines();
        if (lines == null) {
            return -1;
        }
        for (int i = 0; i < lines.size(); ++i) {
            ATELine line = lines.get(i);
            if (line.position <= pos) continue;
            return i - 1;
        }
        return lines.size() - 1;
    }

    public Point getLineTextPositionsAtTextPosition(int pos) {
        return this.getLineTextPositionsAtLineIndex(this.getLineIndexAtTextPosition(pos));
    }

    public Point getLineTextPositionsAtLineIndex(int lineIndex) {
        List<ATELine> lines = this.getLines();
        if (lineIndex == -1 || lines == null) {
            return null;
        }
        ATELine startLine = lines.get(lineIndex);
        int start = startLine.position;
        if (lineIndex + 1 >= lines.size()) {
            return new Point(start, this.getTextPane().getDocument().getLength() - 1);
        }
        ATELine endLine = lines.get(lineIndex + 1);
        int end = endLine.position;
        return new Point(start, end - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadText(String text) {
        this.setEnableRecordChange(false);
        try {
            this.ateEngineBeforeParsing();
            this.textPane.setText(ATEPanel.normalizeText(text));
            if (this.engine != null) {
                this.engine.processSyntax();
            }
            this.textPane.setCaretPosition(0);
            this.textPane.moveCaretPosition(0);
            this.textPane.getCaret().setSelectionVisible(true);
            this.ateEngineAfterParsing();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.setEnableRecordChange(true);
        }
    }

    public void setText(String text) {
        Document doc = this.textPane.getDocument();
        this.getTextPaneUndo().beginUndoGroup("setText");
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.getTextPaneUndo().endUndoGroup();
    }

    public void insertText(int index, String text) {
        try {
            this.textPane.getDocument().insertString(index, ATEPanel.normalizeText(text), null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void replaceSelectedText(String replace) {
        this.replaceText(this.getSelectionStart(), this.getSelectionEnd(), replace);
    }

    public void replaceText(int start, int end, String text) {
        this.getTextPaneUndo().beginUndoGroup("replaceText");
        try {
            this.textPane.getDocument().remove(start, end - start);
            this.textPane.getDocument().insertString(start, ATEPanel.normalizeText(text), null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.getTextPaneUndo().endUndoGroup();
    }

    public static String normalizeText(String text) {
        return text.replaceAll(System.getProperty("line.separator"), unixEndOfLine);
    }

    public void selectTextRange(int start, int end) {
        this.textPane.setCaretPosition(start);
        this.textPane.moveCaretPosition(end);
        this.textPane.getCaret().setSelectionVisible(true);
        this.scrollCenterToPosition(start, false);
    }

    public void deselectTextRange() {
        this.textPane.setCaretPosition(this.textPane.getCaretPosition());
    }

    public void print() throws PrinterException {
        new ATEPrintUtility().print();
    }

    public void textPaneDidPaint(Graphics g) {
        if (this.underlyingManager != null) {
            this.underlyingManager.paint(g);
        }
    }

    public void textPaneInvokePopUp(Component component, int x, int y) {
        if (this.delegate != null) {
            this.delegate.ateInvokePopUp(component, x, y);
        }
    }

    protected void createTextPane(StyledEditorKit editorKit) {
        this.textPane = new ATETextPane(this, editorKit);
        this.textPane.setFocusable(true);
        this.textPane.setBackground(Color.white);
        this.textPane.setBorder(null);
        this.textPane.setWordWrap(false);
        this.textPaneListener = new TextPaneListener();
        this.textPane.getDocument().addDocumentListener(this.textPaneListener);
        this.textPane.getDocument().putProperty("__EndOfLine__", unixEndOfLine);
        this.cl = new TextPaneCaretListener();
        this.textPane.addCaretListener(this.cl);
        this.ml = new TextPaneMouseAdapter();
        this.textPane.addMouseListener(this.ml);
        this.mml = new TextPaneMouseMotionAdapter();
        this.textPane.addMouseMotionListener(this.mml);
        this.smoothScrolling = new XJSmoothScrolling(this.textPane, this);
        this.gutter = new ATEGutter(this);
        this.keyBindings = new ATEKeyBindings(this.getTextPane());
        JScrollPane textScrollPane = new JScrollPane(this.textPane);
        textScrollPane.setWheelScrollingEnabled(true);
        textScrollPane.setRowHeaderView(this.gutter);
        this.analysisColumn = new ATEAnalysisColumn(this);
        this.analysisColumn.setMinimumSize(new Dimension(ANALYSIS_COLUMN_WIDTH, 0));
        this.analysisColumn.setMaximumSize(new Dimension(ANALYSIS_COLUMN_WIDTH, Integer.MAX_VALUE));
        this.analysisColumn.setPreferredSize(new Dimension(ANALYSIS_COLUMN_WIDTH, this.analysisColumn.getPreferredSize().height));
        Box box = Box.createHorizontalBox();
        box.add(textScrollPane);
        box.add(this.analysisColumn);
        this.add((Component)box, "Center");
    }

    public ATETextPane getTextPane() {
        return this.textPane;
    }

    public ATEGutter getGutter() {
        return this.gutter;
    }

    public void parse() {
        if (this.engine != null) {
            this.engine.process();
        }
    }

    @Override
    public String getText() {
        return this.getTextPane().getText();
    }

    @Override
    public void ateEngineBeforeParsing() {
        if (this.delegate != null) {
            this.delegate.ateEngineBeforeParsing();
        }
    }

    @Override
    public void ateEngineAfterParsing() {
        if (this.delegate != null) {
            this.delegate.ateEngineAfterParsing();
        }
    }

    public void ateAutoIndent(int offset, int length) {
        if (this.delegate != null) {
            this.delegate.ateAutoIndent(offset, length);
        }
    }

    public void ateColoringWillColorize() {
        this.setEnableRecordChange(false);
        this.disableUndo();
    }

    public void ateColoringDidColorize() {
        this.setEnableRecordChange(true);
        this.enableUndo();
    }

    public XJUndo getTextPaneUndo() {
        return this.parentFrame.getUndo(this.getTextPane());
    }

    public void disableUndo() {
        XJUndo undo = this.getTextPaneUndo();
        if (undo != null) {
            undo.disableUndo();
        }
    }

    public void enableUndo() {
        XJUndo undo = this.getTextPaneUndo();
        if (undo != null) {
            undo.enableUndo();
        }
    }

    public int getTextIndexAtPosition(int x, int y) {
        return this.getTextPane().viewToModel(new Point(x, y));
    }

    public void close() {
        this.textPane.removeCaretListener(this.cl);
        this.textPane.removeMouseListener(this.ml);
        this.textPane.removeMouseMotionListener(this.mml);
        this.keyBindings.close();
        this.textPane.close();
        this.analysisColumn.close();
        this.setParentFrame(null);
        this.setDelegate(null);
    }

    public class ATEPrintUtility
    implements Printable {
        public void print() throws PrinterException {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPrintable(this);
            if (printJob.printDialog()) {
                printJob.print();
            }
        }

        public int print(Graphics g, PageFormat pf, int pageIndex) {
            double pageWidth = pf.getImageableWidth();
            double pageHeight = pf.getImageableHeight();
            double preferredLineWidth = ATEPanel.this.textPane.getUI().getRootView(ATEPanel.this.textPane).getView(0).getPreferredSpan(0);
            double scale = pageWidth / preferredLineWidth;
            double lineHeight = (double)ATEPanel.this.textPane.getFontMetrics(ATEPanel.this.textPane.getFont()).getHeight() * scale;
            double numberOfLinesPerPage = pageHeight / lineHeight;
            double numberOfLines = ATEPanel.this.textPane.getDocument().getDefaultRootElement().getElementCount();
            int totalNumPages = (int)Math.ceil(numberOfLines / numberOfLinesPerPage);
            if (pageIndex >= totalNumPages) {
                return 1;
            }
            Graphics2D g2 = (Graphics2D)g;
            this.disableDoubleBuffering(ATEPanel.this.textPane);
            g2.translate(pf.getImageableX(), pf.getImageableY());
            double offsety = (double)(pageIndex * (int)numberOfLinesPerPage) * lineHeight;
            g2.translate(0.0, -offsety);
            g2.setClip(null);
            g2.clipRect(0, (int)offsety, (int)Math.floor(pageWidth), (int)Math.floor((double)((int)numberOfLinesPerPage) * lineHeight));
            g2.scale(scale, scale);
            ATEPanel.this.textPane.printPaint(g2);
            this.enableDoubleBuffering(ATEPanel.this.textPane);
            return 0;
        }

        public void disableDoubleBuffering(Component c) {
            RepaintManager currentManager = RepaintManager.currentManager(c);
            currentManager.setDoubleBufferingEnabled(false);
        }

        public void enableDoubleBuffering(Component c) {
            RepaintManager currentManager = RepaintManager.currentManager(c);
            currentManager.setDoubleBufferingEnabled(true);
        }
    }

    protected class TextPaneMouseMotionAdapter
    extends MouseMotionAdapter {
        protected TextPaneMouseMotionAdapter() {
        }

        public void mouseMoved(MouseEvent e) {
            if (ATEPanel.this.delegate != null) {
                ATEPanel.this.delegate.ateMouseMoved(e);
            }
        }
    }

    protected class TextPaneMouseAdapter
    extends MouseAdapter {
        protected TextPaneMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            if (ATEPanel.this.textPane.highlightCursorLine) {
                ATEPanel.this.textPane.repaint();
            }
            this.checkForPopupTrigger(e);
            if (ATEPanel.this.delegate != null) {
                ATEPanel.this.delegate.ateMousePressed(e.getPoint());
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.checkForPopupTrigger(e);
        }

        public void checkForPopupTrigger(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int index = ATEPanel.this.textPane.viewToModel(e.getPoint());
                if (ATEPanel.this.textPane.getSelectionStart() != ATEPanel.this.textPane.getSelectionEnd()) {
                    if (index < ATEPanel.this.textPane.getSelectionStart() || index > ATEPanel.this.textPane.getSelectionEnd()) {
                        ATEPanel.this.setCaretPosition(index, false, false);
                    }
                } else if (index != ATEPanel.this.getCaretPosition()) {
                    ATEPanel.this.setCaretPosition(index, false, false);
                }
                ATEPanel.this.textPaneInvokePopUp(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (ATEPanel.this.delegate != null) {
                ATEPanel.this.delegate.ateMouseExited();
            }
        }
    }

    protected class TextPaneListener
    implements DocumentListener {
        protected int enable = 0;

        protected TextPaneListener() {
        }

        public synchronized void enable() {
            --this.enable;
        }

        public synchronized void disable() {
            ++this.enable;
        }

        public synchronized boolean isEnable() {
            return this.enable == 0;
        }

        public void changeUpdate(int offset, int length, boolean insert) {
            if (this.isEnable()) {
                if (ATEPanel.this.delegate != null) {
                    ATEPanel.this.delegate.ateChangeUpdate(offset, length, insert);
                }
                if (insert) {
                    ATEPanel.this.autoIndent.indent(offset, length);
                }
                if (ATEPanel.this.gutter != null) {
                    ATEPanel.this.gutter.changeUpdate(offset, length, insert);
                }
                ATEPanel.this.changeOccurred();
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.changeUpdate(e.getOffset(), e.getLength(), true);
        }

        public void removeUpdate(DocumentEvent e) {
            this.changeUpdate(e.getOffset(), -e.getLength(), false);
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    protected class TextPaneCaretListener
    implements CaretListener {
        protected TextPaneCaretListener() {
        }

        public void caretUpdate(CaretEvent e) {
            if (ATEPanel.this.delegate != null) {
                ATEPanel.this.delegate.ateCaretUpdate(e.getDot());
            }
            if (ATEPanel.this.textPane.highlightCursorLine) {
                ATEPanel.this.textPane.repaint();
            }
        }
    }
}

