/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar;

import java.util.ArrayList;
import java.util.List;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.grammar.GrammarDOTTab;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.xjlib.appkit.utils.XJAlert;

public class RulesDependency
extends GrammarDOTTab {
    protected List<String> visitedRules = new ArrayList<String>();
    protected List<String> visitedRefs = new ArrayList<String>();
    protected StringBuilder dependency;
    protected boolean includeLexerRefs;

    public RulesDependency(GrammarWindow window) {
        super(window);
    }

    protected boolean willLaunch() {
        if (!this.checkForCurrentRule()) {
            return false;
        }
        ElementRule rule = this.window.getCurrentRule();
        List<ElementReference> refs = this.window.editorRules.getReferencesInRule(rule);
        if (refs == null || refs.isEmpty()) {
            XJAlert.display(this.window.getJavaContainer(), "Error", "The selected rule doesn't contain any references");
            return false;
        }
        this.includeLexerRefs = true;
        if (!rule.lexer && this.window.getGrammarEngine().isCombinedGrammar()) {
            this.includeLexerRefs = XJAlert.displayAlertYESNO(this.window.getJavaContainer(), "Rule Dependency Graph", "Do you want to include lexer references ?") == 0;
        }
        return true;
    }

    public String getDOTString() throws Exception {
        ElementRule rule = this.window.getCurrentRule();
        this.visitedRules.clear();
        this.visitedRefs.clear();
        this.dependency = new StringBuilder();
        this.dependency.append("digraph {\n");
        this.buildGraph(rule);
        this.dependency.append("}");
        return this.dependency.toString();
    }

    protected void buildGraph(ElementRule rule) {
        if (rule == null) {
            return;
        }
        this.visitedRules.add(rule.name);
        List<ElementReference> refs = this.window.editorRules.getReferencesInRule(rule);
        if (refs == null || refs.isEmpty()) {
            return;
        }
        for (ElementReference reference : refs) {
            String refRuleName = reference.token.getAttribute();
            String visitedRef = rule.name + " -> " + refRuleName;
            if (this.visitedRefs.contains(visitedRef) || ATEToken.isLexerName(reference.token.getAttribute()) && !this.includeLexerRefs) continue;
            this.visitedRefs.add(visitedRef);
            this.dependency.append(visitedRef);
            this.dependency.append(";\n");
            if (this.visitedRules.contains(refRuleName)) continue;
            this.buildGraph(this.window.getGrammarEngine().getRuleWithName(refRuleName));
        }
    }

    public String getTabName() {
        return "Dependency of \"" + this.rule.name + "\"";
    }
}

