/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.find.Usages;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.menu.FindMenuDelegate;
import org.antlr.works.stats.StatisticsAW;

public class FindMenu {
    private final FindMenuDelegate delegate;

    public FindMenu(FindMenuDelegate delegate) {
        this.delegate = delegate;
    }

    public void find() {
        this.delegate.find();
    }

    public void findNext() {
        StatisticsAW.shared().recordEvent(11);
        this.delegate.getFindAndReplace().next();
    }

    public void findPrev() {
        StatisticsAW.shared().recordEvent(12);
        this.delegate.getFindAndReplace().prev();
    }

    public void findSelection() {
        StatisticsAW.shared().recordEvent(13);
        this.delegate.getFindAndReplace().setFindString(this.delegate.getTextEditor().getSelectedText());
        this.delegate.getFindAndReplace().next();
    }

    public void findUsage() {
        StatisticsAW.shared().recordEvent(14);
        ATEToken token = this.delegate.getCurrentToken();
        if (token == null) {
            return;
        }
        Usages usage = new Usages(this.delegate, token);
        this.delegate.addUsagesTab(usage);
        for (ATEToken ateToken : this.delegate.getTokens()) {
            ElementRule matchedRule;
            if (!ateToken.getAttribute().equals(token.getAttribute()) || (matchedRule = this.delegate.getEditorRules().getEnclosingRuleAtPosition(ateToken.getStartIndex())) == null) continue;
            usage.addMatch(matchedRule, ateToken);
        }
    }
}

