/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.grammar.RefactorMutator;
import org.antlr.works.menu.ActionRefactor;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.stringtemplate.STWindow;
import org.antlr.works.stringtemplate.element.ElementTemplateRule;
import org.antlr.xjlib.appkit.undo.XJUndo;

public class STRefactorMenu
implements ActionRefactor {
    private final STWindow window;
    private EditorTextMutator mutator;

    public STRefactorMenu(STWindow window) {
        this.window = window;
    }

    public void rename() {
        StatisticsAW.shared().recordEvent(60);
        ATEToken token = this.window.getCurrentToken();
        if (token == null) {
            return;
        }
        String s = (String)JOptionPane.showInputDialog(this.window.getJavaContainer(), "Rename '" + token.getAttribute() + "' and its usages to:", "Rename", 3, null, null, token.getAttribute());
        if (s != null && !s.equals(token.getAttribute())) {
            this.beginRefactor("Rename");
            this.renameToken(token, s);
            this.endRefactor();
        }
    }

    public boolean renameToken(ATEToken t, String name) {
        boolean renameRefRule;
        String attr = t.getAttribute();
        List<ATEToken> tokens = this.window.getTokens();
        boolean isArg = t.type == 119 || t.type == 118;
        boolean bl = renameRefRule = t.type == 116 || t.type == 113;
        if (renameRefRule) {
            for (int index = tokens.size() - 1; index > 0; --index) {
                ATEToken token = tokens.get(index);
                if (!token.getAttribute().equals(attr) || token.type != 116 && token.type != 113) continue;
                this.mutator.replace(token.getStartIndex(), token.getEndIndex(), name);
            }
        } else if (isArg) {
            ElementTemplateRule rule = this.getRuleAtPosition(this.window.getCaretPosition());
            for (int index = tokens.size() - 1; index > 0; --index) {
                ATEToken token = tokens.get(index);
                if (!token.getAttribute().equals(attr) || !rule.containsIndex(token.start) || token.type != 119 && token.type != 118) continue;
                this.mutator.replace(token.getStartIndex(), token.getEndIndex(), name);
            }
        } else {
            this.mutator.replace(t.getStartIndex(), t.getEndIndex(), name);
        }
        return true;
    }

    protected ElementTemplateRule getRuleAtPosition(int pos) {
        List<ElementTemplateRule> rules = this.window.getRules();
        if (rules == null) {
            return null;
        }
        for (ElementTemplateRule rule : rules) {
            if (!rule.containsIndex(pos)) continue;
            return rule;
        }
        return null;
    }

    protected void beginRefactor(String name) {
        this.window.beginGroupChange(name);
        this.mutator = new EditorTextMutator();
    }

    protected void endRefactor() {
        this.mutator.apply();
        this.mutator = null;
        this.window.endGroupChange();
    }

    public boolean canReplaceLiteralWithTokenLabel() {
        return false;
    }

    public void replaceLiteralWithTokenLabel() {
    }

    public void replaceLiteralTokenWithTokenLabel(ATEToken t, String name) {
    }

    public void convertLiteralsToSingleQuote() {
    }

    public void convertLiteralsToDoubleQuote() {
    }

    public void convertLiteralsToCStyleQuote() {
    }

    public void removeLeftRecursion() {
    }

    public void removeAllLeftRecursion() {
    }

    public boolean canExtractRule() {
        return false;
    }

    public void extractRule() {
    }

    public boolean canInlineRule() {
        return false;
    }

    public void inlineRule() {
    }

    public void createRuleAtIndex(boolean lexer, String name, String content) {
    }

    public void deleteRuleAtIndex(int index) {
    }

    public int insertionIndexForRule(boolean lexer) {
        return -1;
    }

    public String createRule(String name, String content) {
        return null;
    }

    protected void refactorReplaceEditorText(String text) {
        int oldCaretPosition = this.window.getCaretPosition();
        this.window.disableTextPaneUndo();
        this.window.setText(text);
        this.window.enableTextPaneUndo();
        this.window.getTextEditor().setCaretPosition(Math.min(oldCaretPosition, text.length()), false, false);
    }

    protected class UndoableRefactoringEdit
    extends AbstractUndoableEdit {
        public String oldContent;
        public String newContent;

        public UndoableRefactoringEdit(String oldContent, String newContent) {
            this.oldContent = oldContent;
            this.newContent = newContent;
        }

        public void redo() {
            super.redo();
            STRefactorMenu.this.refactorReplaceEditorText(this.newContent);
        }

        public void undo() {
            super.undo();
            STRefactorMenu.this.refactorReplaceEditorText(this.oldContent);
        }
    }

    public class EditorTextMutator
    implements RefactorMutator {
        public StringBuilder mutableText;

        public EditorTextMutator() {
            this.mutableText = new StringBuilder(STRefactorMenu.this.window.getText());
        }

        public void replace(int start, int end, String s) {
            this.mutableText.replace(start, end, s);
        }

        public void insert(int index, String s) {
            this.mutableText.insert(index, s);
        }

        public void insertAtLinesBoundary(int index, String s) {
            if (this.mutableText.charAt(index) != '\n' || this.mutableText.charAt(index - 1) != '\n') {
                this.mutableText.insert(index++, '\n');
            }
            this.mutableText.insert(index, s);
            int end = index + s.length();
            if (this.mutableText.charAt(end) != '\n' || end + 1 >= this.mutableText.length() || this.mutableText.charAt(end + 1) != '\n') {
                this.mutableText.insert(end, '\n');
            }
        }

        public void delete(int start, int end) {
            this.mutableText.delete(start, end);
        }

        public void apply() {
            String text = this.mutableText.toString();
            String oldContent = STRefactorMenu.this.window.getText();
            STRefactorMenu.this.refactorReplaceEditorText(text);
            XJUndo undo = STRefactorMenu.this.window.getUndo(STRefactorMenu.this.window.getTextPane());
            undo.addEditEvent(new UndoableRefactoringEdit(oldContent, text));
        }
    }
}

