/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.editor.EditorInspectorItem;
import org.antlr.works.editor.idea.IdeaAction;
import org.antlr.works.editor.idea.IdeaManager;
import org.antlr.works.editor.idea.IdeaManagerDelegate;
import org.antlr.works.editor.idea.IdeaOverlay;
import org.antlr.works.editor.idea.IdeaProvider;
import org.antlr.works.grammar.element.ElementRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorIdeas
implements IdeaManagerDelegate,
IdeaProvider {
    public IdeaManager ideaManager;
    public GrammarWindow window;

    public EditorIdeas(GrammarWindow window) {
        this.window = window;
    }

    public void awake() {
        this.ideaManager = new IdeaManager();
        this.ideaManager.setOverlay(new IdeaOverlay(this.window, (JComponent)this.window.getTextPane()));
        this.ideaManager.addProvider(this);
        this.ideaManager.setDelegate(this);
    }

    public void close() {
        this.window = null;
        this.ideaManager.close();
    }

    public void hide() {
        this.ideaManager.hide();
    }

    public void toggleEnabled() {
        this.ideaManager.setEnabled(!this.ideaManager.enabled());
    }

    public boolean isEnabled() {
        return this.ideaManager.enabled();
    }

    @Override
    public List<IdeaAction> ideaProviderGetActions(int position) {
        ArrayList<IdeaAction> actions = new ArrayList<IdeaAction>();
        List<EditorInspectorItem> items = this.window.editorInspector.getAllItemsAtIndex(position);
        for (EditorInspectorItem item : items) {
            List<IdeaAction> itemActions = item.getIdeaActions();
            if (itemActions == null) continue;
            actions.addAll(itemActions);
        }
        return actions;
    }

    @Override
    public boolean ideaManagerWillDisplayIdea() {
        return !this.window.autoCompletionMenu.isVisible() && this.window.isFileWritable();
    }

    public void display(Point p) {
        this.display(this.window.getTextPane().viewToModel(p));
    }

    public void display(int position) {
        ElementRule enclosingRule = this.window.editorRules.getEnclosingRuleAtPosition(position);
        if (enclosingRule == null || enclosingRule.isExpanded()) {
            this.ideaManager.displayAnyIdeasAvailable(position);
        }
    }
}

