/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.foundation.notification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class XJNotificationCenter {
    private static XJNotificationCenter defaultCenter = new XJNotificationCenter();
    private Map<String, List<XJNotificationObserver>> observers = new HashMap<String, List<XJNotificationObserver>>();

    public static XJNotificationCenter defaultCenter() {
        return defaultCenter;
    }

    public void addObserver(XJNotificationObserver observer, String notifName) {
        List<XJNotificationObserver> obs = this.observers.get(notifName);
        if (obs == null) {
            obs = new ArrayList<XJNotificationObserver>();
            this.observers.put(notifName, obs);
        }
        obs.add(observer);
    }

    public void removeObserver(XJNotificationObserver observer) {
        for (String notifName : this.observers.keySet()) {
            List<XJNotificationObserver> obs = this.observers.get(notifName);
            for (int i = obs.size() - 1; i >= 0; --i) {
                XJNotificationObserver candidate = obs.get(i);
                if (!candidate.equals(observer)) continue;
                obs.remove(i);
            }
        }
    }

    public void postNotification(Object source, String notifName) {
        List<XJNotificationObserver> obs = this.observers.get(notifName);
        if (obs == null) {
            return;
        }
        for (XJNotificationObserver observer : obs) {
            observer.notificationFire(source, notifName);
        }
    }
}

